function fig = plotCellConcatProfile(t_full_vec_M1_NMC25degC,I_full_vec_M1_NMC25degC,V_full_vec_M1_NMC25degC,SOC_drop)

% mainProfiles(prof) 
%  draw post-processing plots.
%
% Input arguments
% ---------------
% prof : struct
%   data structures for the time profiles.
%
% Notes
% ---------------
% The powerflow control variable must be named either prof.vehPrf.engAlpha, 
% prof.vehPrf.engTau or prof.vehPrf.emAlpha.

%% Battery cell singnals

fig = figure;
t = tiledlayout(3,1);

ax1 = nexttile;
plot(t_full_vec_M1_NMC25degC, SOC_drop, 'LineWidth', 1.5, 'Color', '#d62728')
grid on
ylabel("SOC drop, -")

ax2 = nexttile;
plot(t_full_vec_M1_NMC25degC, I_full_vec_M1_NMC25degC, 'LineWidth', 1.5, 'Color', '#d62728')
grid on
ylabel("Cell current, A")

ax3 = nexttile;
plot(t_full_vec_M1_NMC25degC, V_full_vec_M1_NMC25degC, 'LineWidth', 1.5, 'Color', '#1f77b4')
grid on
ylabel("Cell voltage, V")
xlim([-inf,inf])

set(findall(gcf,'-property','FontSize'),'FontSize',16)
xlabel(t, "Time, s", 'FontSize', 16)
linkaxes([ax1 ax2 ax3], 'x')


%% Finalize figure
% fig.Units = 'normalized';
% fig.Position = [0 0 1 1];


